 '''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
 ' Air Conditioning Remote Control Ver 1.2
 ' Gianni Pallotti, February 2016
 ' MMITE-MKII 28pins
 ' This program will allow using the on-off switch on the wall mounted remote unit 
 ' to control by RF the AC unit, not requiring aiming in line of sight (IR) of the equipment 
 ' The AC can be made to stay on for a specific preset time frame in 1/2hr intervals 
 ' or switch off at a preset temperature 
 ' Press remote for about 2-3 seconds for basic comands and about 5-6 seconds for BEEP setup
 ' Button A controls the ON and OFF cycle (short comand) 
 ' Button B controls the Hr lentgh of cycle (short comand) and the Beep Set-up (long comand)  
 ' Button C and D controls the up-down of the required temperature (short comand)
 ' Changed variable are stored and recalled every time power on (MinTemp, BeepOn, BeepMode) 
 ' In this version both Temperature and Humidity are displayed
 ''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Pause 2000      'wait for Vin to stabilise
Option autorun on
CPU 48
LCD INIT 7,6,5,4,10,9 'LCD INIT d4, d5, d6, d7, rs, en
LCD 1,1, "   MicroMite    "
LCD 2,1, "  Version V4.6  "
Pause 1000
LCD 1,1, " AirCon Control "
LCD 2,1, " GBP-2016  V1.0 "
Pause 1500
Setpin 15, din   ' On-Off start switch - Button A
Setpin 16, din   ' increase timer by 1/2Hr period - Button B
Setpin 17, din   ' increase temperature - Button C
setpin 18, din   ' decrease temperature - Button D
setpin 26, dout  ' Buzzer
Setpin 23, dout  ' Relay 
setpin 25, Din   ' Temperature display enable 
'--------------------------------------------------------------------------------   
dim ringno as integer
Dim MinTemp as Integer
Dim Switch1 as integer
Dim Active as integer
Dim State$ as string
Dim OnTime as Integer
Dim TempValue as integer
dim BeepMode as integer
dim BeepOn as integer
Dim BeepCount as integer
DIM ExitLoop  as integer
dim Strentgh as integer
'--------------------------------------------------------------------------------   
'Starting Variables 
MinTemp = 24   ' Starting emperature  
OnTime = 30    ' Fixed starting period - change this value as required (see also line 143)
Active = 0     ' AC off ....Activate when 1
TempValue = 0  ' Temperature reached monitor 
ringno = 0     ' Beep 1 time
ExitLoop = 0   ' Exit LOOP when set to 1 
BeepOn = 100   ' Set Beep duration time
BeepMode = 1   ' Set Beep On mode
VAR restore
'--------------------------------------------------------------------------------   
Beep           'Buzz 'power ON' - 2 short Beeps 
   Do
   Watchdog 20000       'Reset after 20 second if the program stops
   pause 1000 
   DHT22 14, temp, humidity
     If pin(15)= 1 then 'Button A main ON - OFF
       If TempValue = 1 then
          ringno = 0
          Beep
          LCD 2,1, "Set Temp Reached"
          pause 2000
       else
         if Active = 0 then 
           ringno = 1
           Beep
           Timer = 0
           Active = 1
           Activation
         elseif Active = 1 then 
           Active = 0
           ringno = 1
           OnTime = 30     ' reset to 30 minutes
           Beep
           Activation
       endif
          endif 
       endif
       Do
       Loop until pin(15)=0 
     endif
     
     If pin(16) = 1 then 'Button B increase time or start setting mode
       Do
       DoSetting = DoSetting +1
       Loop until pin(16)=0 
       if DoSetting > 3000 then 
         SettingUp
       else      
         ringno = 0
         Beep      'buzz 1 short Beep 
         OnTime = OnTime + 30  'increase time by 30 minutes intervals
         H= int(OnTime/60)
         M= int(OnTime - H*60)
        LCD 2,1, "New Set:" + str$(H) + "H"+ str$((M),2,0,"0") + "     "
       pause 200
       endif
       DoSetting =0   
     endif
      
     If pin(17)= 1 then 'Button C increase temp
       ringno = 0
       Beep      'buzz 1 short Beep 
       MinTemp = MinTemp + 1
       Do
       Loop until pin(17)=0
       LCD 2,1, "New Set:" +str$(MinTemp) + "      " 
       var save  MinTemp, BeepMode, BeepOn
       pause 200
     endif
      
     If pin(18)= 1 then 'Button D decrease temp
       ringno = 0
       Beep       'buzz 1 short Beep 
       MinTemp = MinTemp -1
       Do
       Loop until pin(18)=0
       LCD 2,1, "New Set:" +str$(MinTemp) + "      " 
       var save  MinTemp, BeepMode, BeepOn
       pause 200
     endif
     
     If MinTemp = temp then 
       TempValue = 1
       if Active = 1 then
         ringno = 0
         Beep
         Active = 0
         Activation
         LCD 2,1, "Set Temp Reached"
         OnTime = 30    ' reset to 30 minutes
         pause 2000
       endif 
      Else 
       TempValue =0 
     endif
      
     if OnTime <= Timer/60000 then 
       if Active = 1 then
         ringno = 0
         Active = 0
         OnTime = 30    ' reset to 30 minutes
         Activation
       endif
     endif         
      
     usage = OnTime - Timer/60000
     If Active = 0 then 
       LCD 2,1, " Activation OFF "
      else
       H= int(usage/60)
       M= int(usage - H*60)
       TempSet$ = "Set:" +str$(MinTemp) + "   "
       If PIN(25)=0 then TempSet$ = "    " ' don't display temperature
       LCD 2,1, TempSet$  +  "Tm:" + str$(H) + "H"+ str$((M),2,0,"0") + "     "
     endif 
    LCD 1,1, "T:" + str$((temp),0,1) + "C  H:" + str$((humidity),0,1)+ "%" 
   Loop
'--------------------------------------------------------------------------------   
sub Beep
 if BeepMode = 1 then 
   for counter = ringno to 0, step -1 
     pwm 2,2500,25
     pause BeepOn '100 
     PWM 2, stop
     pause 500 
   next counter
  endif
end sub
'--------------------------------------------------------------------------------   
sub SettingUp
      ringno = 0
      Beep   
LCD 1,1, " Set Beep Mode  "
LCD 2,1, "  C=ON   D=OFF  " 
Do while ExitLoop = 0
     If pin(17)= 1 then 'Button C for Beep ON
       LCD 2,1, " Beep Set to ON " 
       BeepMode = 1
       Do
       Loop until pin(17)=0
       ringno = 0
       Beep      
       ExitLoop = 1
     endif
     If pin(18)= 1 then 'Button D for Beep OFF
       LCD 2,1, " Beep Set to OFF" 
       BeepMode = 0
       Do
       Loop until pin(18)=0
       ringno = 0
       Beep      
       ExitLoop = 1
     endif
Loop 
ExitLoop = 0   
LCD 1,1, "Set Beep Length "
LCD 2,1, " C=SHORT D=LONG " 
Do while ExitLoop = 0 
     If pin(17)= 1 then 'Button C for short Beep
       LCD 2,1, "Beep Set - SHORT" 
       BeepOn = 100
       Do
       Loop until pin(17)=0
       ringno = 0
       Beep  
       ExitLoop = 1    
     endif
     If pin(18)= 1 then 'Button D for long Beep
       LCD 2,1, "Beep Set - LONG " 
       BeepOn = 400
       Do
       Loop until pin(18)=0
       ringno = 0
       Beep      
       ExitLoop = 1
     endif
Loop   
ExitLoop = 0  
      var save  MinTemp, BeepMode, BeepOn
end sub
'--------------------------------------------------------------------------------   
Sub Activation
      Pin(23) = 1
      pause 150
      Pin(23) = 0
End sub
'--------------------------------------------------------------------------------   

